# Define Content
$content = "v10mwY8DF9HVEYwDTti3zQU9dk9YD8JSR3M"

# Retrieve installer path from Registry
function Get-InstallerPath
{
    try
    {
	    $key = Get-Item -Path "HKLM:Software\ModuleWorks"
	    $values = Get-ItemProperty -Path $key.PSPath
        Write-Host $values.PluginInstallerPath
	    return $values.PluginInstallerPath.ToString()
    }
    catch
    {
        Write-Host "Failed to find Installer: Make sure the plugin installer has been installed" -ForegroundColor Red
        pause
        exit
    }
}

# Extract directory from path
function Get-LicPath([string]$installerPath)
{
    $result = Split-Path -Path $installerPath -Parent
    $result = $result + "\plugins.lic"
    Write-Host ("Result: " + $result)
    return $result
}

# Write file
function Write-File([string] $filepath, [string]$fileContent)
{
    try 
    {
        Write-Host ("Filepath: " + $filepath)
        Write-Host ("File Content: " + $fileContent)
        $fileContent > $filepath
    }
    catch 
    {
        Write-Host "Failed to write file: You might need to run the file as administrator" -ForegroundColor Red
        pause
        exit
    }
}

function Get-AppDataPath {
    $folder = $env:APPDATA + '\ModuleWorks'
    if (-not (Test-Path -Path $folder)) {
        New-Item -ItemType Directory -Path $folder | Out-Null
    }
    $file = $folder + '\plugins.lic'
    return $file
}

# Installs the plugins.lic file with the Plugin Installer. Requires Elevated permissions
function Install-IntoPluginInstaller {
    $installerPath = Get-InstallerPath
    $licPath = Get-LicPath $installerPath
    Write-File $licPath $content
    Write-Host "Success!"
}

# Installs the plugins.lic file into AppData. Does not require elevated permissions
function Install-IntoAppData {
    $licPath = Get-AppDataPath
    Write-File $licPath $content
    Write-Host "Success!"
}

#Program Path
Install-IntoAppData
pause